﻿using System;
using System.Linq;

namespace VIRP.EFR.BO
{
    public class ImageStudies
    {
        private const string StudyImageType = "IMAGE";

        private readonly Study[] Studies;

        public ImageStudies(Study[] studies)
        {
            this.Studies = studies;
        }

        public Study[] EncodedImageStudies
        {
            get
            {
                if (this.Studies != null && this.Studies.Any())
                {
                    var tryGetImageStudies = this.Studies
                        .Where(s => s.StudyType.Equals(StudyImageType, StringComparison.OrdinalIgnoreCase));

                    if (tryGetImageStudies != null && tryGetImageStudies.Any())
                        foreach (var study in tryGetImageStudies)
                            study.EncodeJsonStrings();

                    return tryGetImageStudies.ToArray();
                }

                return null;
            }
        }

        public int? ImageStudyCount
        {
            get
            {
                if (this.Studies != null && this.Studies.Any())
                {
                    return this.Studies
                        .Where(s => s.StudyType.Equals(StudyImageType, StringComparison.OrdinalIgnoreCase))
                        .Count();
                }

                return null;
            }
        }
    }
}